# Backend Server Test Guide

## Server is Running! 🎉

The backend server is now running on http://localhost:3000

## Quick Test Commands

### 1. Test Health Endpoint
```bash
curl http://localhost:3000/api/health
```

### 2. Login with Admin Account
```bash
curl -X POST http://localhost:3000/api/auth/login -H "Content-Type: application/json" -d "{\"username\":\"admin\",\"password\":\"admin123\"}"
```

Expected response:
```json
{
  "success": true,
  "message": "Login successful",
  "token": "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9...",
  "user": {
    "id": 1,
    "username": "admin",
    "email": "admin@zarnaira.com",
    "role": "admin"
  }
}
```

**Important:** Copy the token from the response for the next requests.

### 3. Change Password (Use token from login)
Replace `YOUR_TOKEN_HERE` with the actual token from the login response:

```bash
curl -X POST http://localhost:3000/api/auth/change-password -H "Content-Type: application/json" -H "Authorization: Bearer YOUR_TOKEN_HERE" -d "{\"currentPassword\":\"admin123\",\"newPassword\":\"NewSecure123\",\"confirmPassword\":\"NewSecure123\"}"
```

### 4. Get Exchange Rates (Public)
```bash
curl http://localhost:3000/api/exchange/rates
```

### 5. Submit Exchange Request (Public)
```bash
curl -X POST http://localhost:3000/api/exchange/request -H "Content-Type: application/json" -d "{\"name\":\"John Doe\",\"email\":\"john@example.com\",\"phone\":\"+27123456789\",\"amount\":1000,\"currencyFrom\":\"ZAR\",\"currencyTo\":\"NGN\"}"
```

### 6. Get All Exchange Requests (Admin - Requires Token)
```bash
curl http://localhost:3000/api/exchange/requests -H "Authorization: Bearer YOUR_TOKEN_HERE"
```

### 7. Update Exchange Request Status (Admin)
Replace `1` with the actual request ID:
```bash
curl -X PATCH http://localhost:3000/api/exchange/requests/1 -H "Content-Type: application/json" -H "Authorization: Bearer YOUR_TOKEN_HERE" -d "{\"status\":\"completed\"}"
```

### 8. Update Exchange Rates (Admin)
```bash
curl -X PUT http://localhost:3000/api/exchange/rates/ZAR-NGN -H "Content-Type: application/json" -H "Authorization: Bearer YOUR_TOKEN_HERE" -d "{\"buyRate\":22.75,\"sellRate\":23.25\"}"
```

## Using PowerShell (Windows)

If curl doesn't work, use PowerShell's Invoke-RestMethod:

### Login
```powershell
$response = Invoke-RestMethod -Uri "http://localhost:3000/api/auth/login" -Method Post -ContentType "application/json" -Body '{"username":"admin","password":"admin123"}'
$token = $response.token
Write-Host "Token: $token"
```

### Change Password
```powershell
Invoke-RestMethod -Uri "http://localhost:3000/api/auth/change-password" -Method Post -ContentType "application/json" -Headers @{Authorization="Bearer $token"} -Body '{"currentPassword":"admin123","newPassword":"NewSecure123","confirmPassword":"NewSecure123"}'
```

### Get Rates
```powershell
Invoke-RestMethod -Uri "http://localhost:3000/api/exchange/rates" -Method Get
```

## Testing with Postman

1. Open Postman
2. Create a new request
3. Set method and URL according to the endpoints above
4. For protected routes, add Header:
   - Key: `Authorization`
   - Value: `Bearer YOUR_TOKEN_HERE`
5. For POST/PUT/PATCH, set Body to raw JSON

## Features Implemented ✅

- ✅ LowDB JSON database
- ✅ Admin user created (username: admin, password: admin123)
- ✅ JWT authentication
- ✅ Password change feature
- ✅ Exchange request management
- ✅ Exchange rates management
- ✅ Secure password hashing with bcryptjs
- ✅ Input validation
- ✅ CORS enabled
- ✅ Protected admin routes

## Important Security Notes

⚠️ **Before deploying to production:**

1. Change the `JWT_SECRET` in the `.env` file
2. Change the admin password immediately after first login
3. Update the `.env` file with production database path
4. Enable HTTPS in production
5. Set appropriate CORS origins (not wildcard)

## Stopping the Server

Press `Ctrl+C` in the terminal where the server is running.

## Restarting the Server

```bash
cd backend
node server.js
```

Or for development with auto-restart:
```bash
npm run dev
```
